@ECHO OFF
REM ============================================================================
REM # Copyright (C) 2022 Schneider Electric. All Rights Reserved.
REM # Version 1.0 : New Release
REM ============================================================================
PUSHD %~dp0
OPENFILES > NUL 2>&1
IF NOT %ERRORLEVEL% EQU 0 GOTO NOTADMIN

.\bin\DIDO_Config1 /u
IF %ERRORLEVEL% EQU -1 GOTO END
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
IF %ERRORLEVEL% EQU 1 GOTO UPDATE1
IF %ERRORLEVEL% EQU 2 GOTO UPDATE2
IF %ERRORLEVEL% EQU 3 GOTO UPDATE3
GOTO END

:UPDATE1
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND1
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE1

:DRIVERFOUND1
ECHO Driver found.

:UPDATE1
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE2
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND2
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE2

:DRIVERFOUND2
ECHO Driver found.

:UPDATE2
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:UPDATE3
pnputil /enum-drivers | find "sttube.inf" > NUL 2>&1
IF %ERRORLEVEL% EQU 0 GOTO DRIVERFOUND3
ECHO Driver not installed.
ECHO Installing driver for update.
pnputil /add-driver .\bin\sttube.inf /install > NUL 2>&1
ECHO Driver installed.
GOTO UPDATE3

:DRIVERFOUND3
ECHO Driver found.

:UPDATE3
TIMEOUT /T 5 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /1 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL

TIMEOUT /T 3 /NOBREAK > NUL 2>&1
.\bin\DIDO_Config2 /2 .\bin\DIDO_APP_FW_v1.5.1_0151.dfu
IF %ERRORLEVEL% EQU -1 GOTO UPDATEFAIL
IF %ERRORLEVEL% EQU 0 GOTO SETCONFIG
GOTO END

:SETCONFIG
.\bin\DIDO_Config1 /R
GOTO END

:UPDATEFAIL
ECHO Update failed.
GOTO END

:NOTADMIN
ECHO Please run as administrator.

:END
POPD
PAUSE
